/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.pa.util;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.msgsvc.Message;
import com.ibm.hwmca.fw.util.msgsvc.MessageService;
import com.ibm.hwmca.fw.util.msgsvc.RemoteEntity;
import java.io.File;
import java.util.HashSet;
import java.util.Set;

public class PAPublication {
    private static final String TRACE_MASKT = "XPAPPUBT";
    private static final String TRACE_MASKF = "XPAPPUBF";
    private static final String TRACE_MASKD = "XPAPPUBD";
    private static final String PUBLISH_FILE_LOCATION = "paconfig";
    private static final String PUBLISH_FILE_NAME = "publish.enable";
    private static boolean publicationEnabled = false;

    public static boolean isPublicationEnabled() {
        boolean gotFile = false;
        try {
            String path = BaseFileControl.getFilePath(PUBLISH_FILE_LOCATION);
            if (path != null) {
                File enableFile = new File(path + PUBLISH_FILE_NAME);
                if (enableFile.exists()) {
                    Trace.trace(TRACE_MASKD, "publish.enable exists");
                    gotFile = true;
                } else {
                    Trace.trace(TRACE_MASKD, "publish.enable doesn't exist");
                    gotFile = false;
                }
            } else {
                Trace.trace(TRACE_MASKD, "got a null path from dfc");
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "got a dfc exception");
            Trace.trace(TRACE_MASKF, e);
        }
        if (gotFile) {
            if (!publicationEnabled) {
                publicationEnabled = true;
                Trace.trace(TRACE_MASKF, "Publication enabled");
            }
        } else if (publicationEnabled) {
            publicationEnabled = false;
            Trace.trace(TRACE_MASKF, "Publication disabled");
        }
        return publicationEnabled;
    }

    public static void queuePublication(RemoteEntity receiver, Message msg) throws HException {
        HashSet<RemoteEntity> receiverSet = new HashSet<RemoteEntity>();
        receiverSet.add(receiver);
        PAPublication.queuePublication(receiverSet, msg);
    }

    public static void queuePublication(Set receiverSet, Message msg) throws HException {
        if (!PAPublication.isPublicationEnabled()) {
            throw new HException("PA publication disabled");
        }
        MessageService.getMessageService().publishToRemote(msg, receiverSet, true, false);
    }
}

